# token_app/serializers.py
from rest_framework import serializers

from .models import Token


class TokenSerializer(serializers.ModelSerializer):
    # address را از فیلد واقعی مدل مپ کن (مثلاً contract_address)
    address = serializers.CharField(source="contract_address", read_only=True)

    class Meta:
        model = Token
        fields = ["id", "symbol", "name", "decimals", "address", "usd_price"]
