from django.contrib import admin

from .models import Token, TokenSettings


@admin.register(TokenSettings)
class TokenSettingsAdmin(admin.ModelAdmin):
    list_display = ["token", "receiver_address", "gas_limit"]


@admin.register(Token)
class TokenAdmin(admin.ModelAdmin):
    list_display = ("id", "symbol", "name", "decimals", "usd_price")
    search_fields = ("symbol", "name")
    list_editable = ("usd_price",)
