from django.core.management.base import BaseCommand
from django.contrib.auth import get_user_model
from apps.events.services import evaluate_and_reward_for_user

User = get_user_model()

class Command(BaseCommand):
    help = "Evaluate active tasks for all users and activate rewards"

    def handle(self, *args, **options):
        total = 0
        for u in User.objects.filter(is_active=True).only("id"):
            total += evaluate_and_reward_for_user(u)
        self.stdout.write(self.style.SUCCESS(f"Events: activated {total} rewards"))