# apps/core/utils/percentages.py
from decimal import Decimal

from apps.badges.services import user_badge_bonus_bp


def user_badge_bonus_decimal(user) -> Decimal:
    bp = user_badge_bonus_bp(user)
    return (Decimal(bp) / Decimal(10000)).quantize(Decimal("0.0001"))


def compute_effective_percent(user, base_percent: Decimal) -> Decimal:
    """
    ترکیب اثر ریفرال (موجود) + اثر نشان‌ها.
    مدل فعلی: eff = referral_eff * (1 + badge_bonus)
    """
    ref_eff = referral_effect(user, base_percent)
    badge_bonus = user_badge_bonus_decimal(user)
    return (ref_eff * (Decimal(1) + badge_bonus)).quantize(Decimal("0.0001"))
