# apps/core/utils/decimals.py
from decimal import ROUND_DOWN, ROUND_HALF_UP, Decimal

Q_BP = Decimal("0.0001")  # برای درصد با 4 رقم اعشار (4.6350)
Q_USD = Decimal("0.01")  # پولی/دلاری
Q_TOKEN18 = Decimal("0.000000000000000001")


def q_percent(v: Decimal) -> Decimal:
    """Quantize percent values to 4 decimals, e.g. 4.6350."""
    return v.quantize(Q_BP, rounding=ROUND_HALF_UP)


def q_usd(v: Decimal) -> Decimal:
    """Quantize money values to cents."""
    return v.quantize(Q_USD, rounding=ROUND_HALF_UP)


def q_token(v: Decimal, decimals: int) -> Decimal:
    """Quantize token amount to its decimals (ROUND_DOWN برای امن‌تر بودن)."""
    unit = Decimal(1) / (Decimal(10) ** decimals)
    return v.quantize(unit, rounding=ROUND_DOWN)
