# apps/claims/management/commands/expire_claim_intents.py
from django.core.management.base import BaseCommand
from django.utils import timezone
import time
from apps.claims.models import ClaimIntent


class BaseCommand(BaseCommand):
    help = "Expire pending ClaimIntents passed their deadline"

    def handle(self, *args, **opts):
        now_ts = int(time.time())
        qs = ClaimIntent.objects.filter(status="pending", deadline__lt=now_ts)
        cnt = qs.update(status="expired")
        self.stdout.write(f"expired: {cnt}")
