from django.core.management.base import BaseCommand

from apps.broadcast.tasks import run_cron


class Command(BaseCommand):
    help = "Process scheduled/sending email campaigns (batch send). Run by cron."

    def add_arguments(self, parser):
        parser.add_argument("--silent", action="store_true", help="Do not print output")

    def handle(self, *args, **options):
        total = run_cron()
        if not options["silent"]:
            self.stdout.write(self.style.SUCCESS(f"Broadcast: sent {total} emails in this run."))
