# apps/badges/serializers.py
from rest_framework import serializers
from .models import Badge, UserBadge

class BadgeSerializer(serializers.ModelSerializer):
    image_url = serializers.SerializerMethodField()
    title = serializers.SerializerMethodField()

    class Meta:
        model = Badge
        fields = ("id","key","name","title","description","type","reward_rate_bp","image_url" , "rarity", "display_order", "is_active",)


    def get_image_url(self, obj):
        request = self.context.get("request")
        if getattr(obj, "image", None):
            try:
                url = obj.image.url
                return request.build_absolute_uri(url) if request else url
            except Exception:
                return None
        return None

    def get_title(self, obj):
        return getattr(obj, "title", None) or getattr(obj, "name", None)

class UserBadgeSerializer(serializers.ModelSerializer):
    badge = BadgeSerializer()

    class Meta:
        model = UserBadge
        fields = ("badge","is_active","awarded_at")
