from django.db import migrations

SQLS = [
    # اگر ستون وجود ندارد، بساز با default=0
    "ALTER TABLE badges_badge ADD COLUMN IF NOT EXISTS sort_order INT NOT NULL DEFAULT 0",
    # اگر بعضی نسخه‌ها ستون را بدون default ساخته‌اند، این خط default را اعمال می‌کند:
    "ALTER TABLE badges_badge MODIFY COLUMN sort_order INT NOT NULL DEFAULT 0",
    # ایندکس اختیاری
    "CREATE INDEX IF NOT EXISTS badges_badge_sort_order_idx ON badges_badge (sort_order)",
]

def forwards(apps, schema_editor):
    with schema_editor.connection.cursor() as cur:
        for stmt in SQLS:
            cur.execute(stmt)

def backwards(apps, schema_editor):
    # نیازی به rollback در پروداکشن نداریم
    pass

class Migration(migrations.Migration):

    dependencies = [
        ("badges", "0002_patch_columns"),  # اگر اسم/شماره قبلی‌ت چیز دیگری است، همونو بگذار
    ]

    operations = [
        migrations.RunPython(forwards, backwards),
    ]
