
# apps/badges/management/commands/recompute_badges.py
from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand

from apps.badges.services import evaluate_badges_for_user, award_top_roi_badge

U = get_user_model()

class Command(BaseCommand):
    help = "Recompute/award all badges for all users"

    def add_arguments(self, parser):
        parser.add_argument("--include-top-roi", action="store_true", default=False)
        parser.add_argument("--roi-threshold", type=float, default=1.5)

    def handle(self, *args, **opts):
        cnt = 0
        for u in U.objects.all().only("id").iterator():
            evaluate_badges_for_user(u)
            cnt += 1
        self.stdout.write(self.style.SUCCESS(f"Recomputed non-ROI badges for {cnt} users."))
        if opts["include_top_roi"]:
            n = award_top_roi_badge(opts["roi_threshold"])
            self.stdout.write(self.style.SUCCESS(f"Awarded TOP_ROI to {n} users (threshold={opts['roi_threshold']})."))
