# apps/wallets/management/commands/process_withdraws.py
from django.core.management.base import BaseCommand

from apps.wallets.models import WithdrawRequest
from apps.wallets.service.withdrawals import process_withdraw_request


class Command(BaseCommand):
    help = "Process queued/pending withdraw requests (mock chain for now)."

    def handle(self, *args, **opts):
        qs = WithdrawRequest.objects.filter(status__in=["pending", "queued"]).order_by("id")
        n = 0
        for wr in qs:
            tx = process_withdraw_request(wr)
            n += 1
            self.stdout.write(self.style.SUCCESS(f"submitted wr#{wr.id} tx={tx.tx_hash}"))
        self.stdout.write(self.style.SUCCESS(f"Processed {n} withdraw requests."))
