from django.db import migrations, transaction


def create_initial_plans(apps, schema_editor):
    Plan = apps.get_model("plans", "Plan")
    Token = apps.get_model("token_app", "Token")

    # اگر هنوز توکنی ساخته نشده، مایگریشن دیتا را رد کن (برای تست/نصب اولیه)
    if not Token.objects.exists():
        return

    # اگر MGC هست، همان را بگیر؛ وگرنه اولین توکن موجود
    token = (
        Token.objects.filter(symbol__iexact="MGC").first() or Token.objects.order_by("id").first()
    )
    if not token:
        # از نظر منطقی اینجا نباید بیاد، ولی برای اطمینان:
        return

    base_price = 5000
    base_power = 1

    with transaction.atomic():
        for level in range(1, 22):  # Plan 1 .. 21
            price = base_price * (2 ** (level - 1))  # دو برابر شونده
            power = base_power * (2 ** (level - 1))  # MH/s هم دو برابر

            # اگر از قبل ساخته شده، آپدیت کن؛ وگرنه بساز
            Plan.objects.update_or_create(
                level=level,
                defaults={
                    "name": f"Plan {level}",
                    "price": price,
                    "power": power,
                    "token": token,
                },
            )


def delete_initial_plans(apps, schema_editor):
    Plan = apps.get_model("plans", "Plan")
    # فقط پلان‌های 1..21 را حذف کن (ایمن‌تر از delete همه)
    Plan.objects.filter(level__gte=1, level__lte=21).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("plans", "0001_initial"),  # همین را مطابق آخرین وضعیت پروژه نگه دار
    ]

    operations = [
        migrations.RunPython(create_initial_plans, delete_initial_plans),
    ]
