from rest_framework.routers import DefaultRouter

from django.urls import include, path

from .views import MinerListPublicView, MinerViewSet, PublicCatalogMetricsView, get_miner_by_amount

router = DefaultRouter()
router.register(r"miners", MinerViewSet, basename="miner")

urlpatterns = [
    path("", include(router.urls)),
    path("get-miner-by-amount/", get_miner_by_amount),
    path("public/", MinerListPublicView.as_view(), name="miners-public-list"),
    path("public/metrics/", PublicCatalogMetricsView.as_view(), name="public-catalog-metrics"),
    path(
        "public/light/", MinerListPublicView.as_view(), {"light": True}, name="miners-public-light"
    ),
]
