# apps/miners/migrations/0007_auto_20250711_0417.py
from django.db import migrations, transaction


def create_initial_miners(apps, schema_editor):
    Miner = apps.get_model("miners", "Miner")
    Plan = apps.get_model("plans", "Plan")
    Token = apps.get_model("token_app", "Token")

    # اگر هیچ توکنی نداریم، امن رد شو (به‌جای raise)
    if not Token.objects.exists():
        return

    # ترجیحاً MGC، وگرنه اولین توکن
    token = (
        Token.objects.filter(symbol__iexact="MGC").first() or Token.objects.order_by("id").first()
    )
    if not token:
        return

    with transaction.atomic():
        # لِول‌های 1 تا 21 را تلاش می‌کنیم بسازیم
        for level in range(1, 22):
            plan = Plan.objects.filter(level=level).first()
            if not plan:
                # اگر پلن مربوطه نیست، فقط از همون لول رد شو
                continue

            miner_obj, _created = Miner.objects.update_or_create(
                name=f"Miner {level}",
                defaults={
                    "plan": plan,
                    # اگر مدل شما فیلد power دارد، از power پلن استفاده می‌کنیم
                    "power": getattr(plan, "power", 0),
                    "is_online": True,
                },
            )

            # اگر Miner در این زمان M2M به نام tokens دارد، توکن را وصل کن
            if hasattr(miner_obj, "tokens"):
                # مطمئن شو دوباره‌کاری نمی‌شود
                if not miner_obj.tokens.filter(pk=token.pk).exists():
                    miner_obj.tokens.add(token)


def delete_initial_miners(apps, schema_editor):
    Miner = apps.get_model("miners", "Miner")
    # فقط ماینرهایی که با این نام‌ها ساخته‌ایم را حذف کن
    Miner.objects.filter(name__startswith="Miner ").delete()


class Migration(migrations.Migration):

    dependencies = [
        # اینجا عمداً به آخرین مایگریشن miners وابسته شدیم
        # تا رجیستری مدل با فیلدهای جدید (مثل tokens) در دسترس باشد.
        ("miners", "0011_remove_miner_user"),
        ("plans", "0005_auto_20250711_0330"),
    ]

    operations = [
        migrations.RunPython(create_initial_miners, delete_initial_miners),
    ]
