from django.urls import path, include
from rest_framework.routers import DefaultRouter
from .views import TaskViewSet, RewardViewSet, events_catalog_view,restake_initiate_view,restake_sign_view
from .views_dashboard import events_dashboard_view

# تعریف router برای viewsets
router = DefaultRouter()
router.register(r"tasks", TaskViewSet, basename="events-task")
router.register(r"rewards", RewardViewSet, basename="events-reward")

urlpatterns = [
    path("dashboard/", events_dashboard_view, name="events-dashboard"),
    # path("restake/", restake_view, name="restake"),
    path("restake/initiate/", restake_initiate_view, name="events-restake-initiate"),
    # path("restake/sign/", restake_sign_view, name="restake-sign"),
    path("catalog/", events_catalog_view, name="events-catalog"),
    path("", include(router.urls)),
]
