# Generated by Django 4.2.6 on 2025-11-03 15:05

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("miners", "0015_alter_userminer_is_online"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="EnergyTurboDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=120)),
                (
                    "percent_boost",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=6,
                        validators=[django.core.validators.MinValueValidator(0)],
                    ),
                ),
                ("duration_seconds", models.PositiveIntegerField(default=3600)),
                ("image", models.ImageField(blank=True, null=True, upload_to="rewards/energy/")),
                ("is_active", models.BooleanField(default=True)),
            ],
            options={
                "verbose_name": "Energy Turbo",
                "verbose_name_plural": "Energy Turbos",
            },
        ),
        migrations.CreateModel(
            name="MinerAccessDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=120)),
                ("duration_seconds", models.PositiveIntegerField(default=3600)),
                (
                    "image",
                    models.ImageField(blank=True, null=True, upload_to="rewards/miner_access/"),
                ),
                ("is_active", models.BooleanField(default=True)),
                (
                    "miner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="reward_defs",
                        to="miners.miner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Premium Miner Access",
                "verbose_name_plural": "Premium Miner Accesses",
            },
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.SlugField(max_length=120, unique=True)),
                ("title", models.CharField(max_length=180)),
                ("description", models.TextField(blank=True)),
                (
                    "kind",
                    models.CharField(
                        choices=[
                            ("one_time", "One-time"),
                            ("weekly", "Weekly"),
                            ("monthly", "Monthly"),
                            ("event", "Event (custom window)"),
                        ],
                        default="one_time",
                        max_length=20,
                    ),
                ),
                ("window_start", models.DateTimeField(blank=True, null=True)),
                ("window_end", models.DateTimeField(blank=True, null=True)),
                (
                    "condition_code",
                    models.CharField(
                        choices=[
                            ("login_streak", "Login N days in a row"),
                            ("weekly_restake_all", "Restake all weekly profit"),
                            ("miners_active_window", "All miners active in window"),
                            ("referral_active_count", "N active referrals in window"),
                        ],
                        max_length=40,
                    ),
                ),
                ("condition_params", models.JSONField(blank=True, default=dict)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "reward_type",
                    models.CharField(
                        choices=[
                            ("energy_turbo", "Energy Turbo"),
                            ("miner_access", "Temporary Miner Access"),
                        ],
                        max_length=20,
                    ),
                ),
                ("reward_object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "reward_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Task",
                "verbose_name_plural": "Tasks",
            },
        ),
        migrations.CreateModel(
            name="UserTemporaryMinerAccess",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("starts_at", models.DateTimeField()),
                ("ends_at", models.DateTimeField()),
                ("is_active", models.BooleanField(default=True)),
                (
                    "definition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="events.mineraccessdefinition",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="temp_miner_accesses",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["user", "is_active", "ends_at"],
                        name="events_user_user_id_183801_idx",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="UserTaskProgress",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("completed", "Completed"),
                            ("rewarded", "Rewarded"),
                        ],
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("window_start", models.DateTimeField(blank=True, null=True)),
                ("window_end", models.DateTimeField(blank=True, null=True)),
                ("completed_at", models.DateTimeField(blank=True, null=True)),
                ("rewarded_at", models.DateTimeField(blank=True, null=True)),
                ("meta", models.JSONField(blank=True, default=dict)),
                (
                    "task",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_progress",
                        to="events.task",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="task_progress",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["status", "window_end"], name="events_user_status_e0719c_idx"
                    )
                ],
                "unique_together": {("user", "task", "window_start", "window_end")},
            },
        ),
        migrations.CreateModel(
            name="UserEnergyBoost",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("starts_at", models.DateTimeField()),
                ("ends_at", models.DateTimeField()),
                ("is_active", models.BooleanField(default=True)),
                (
                    "definition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="events.energyturbodefinition",
                    ),
                ),
                (
                    "miner",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="energy_boosts",
                        to="miners.userminer",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="energy_boosts",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["user", "is_active", "ends_at"],
                        name="events_user_user_id_c3f23c_idx",
                    )
                ],
            },
        ),
        migrations.AddIndex(
            model_name="task",
            index=models.Index(fields=["kind", "is_active"], name="events_task_kind_5fc2bb_idx"),
        ),
    ]
