# Generated by Django 4.2.6 on 2025-10-12 20:06

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ClaimTx",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("user_address", models.CharField(db_index=True, max_length=64)),
                ("token_address", models.CharField(db_index=True, max_length=64)),
                (
                    "token_symbol",
                    models.CharField(blank=True, db_index=True, default="", max_length=16),
                ),
                ("amount_scaled", models.DecimalField(decimal_places=0, max_digits=65)),
                ("nonce", models.BigIntegerField()),
                ("tx_hash", models.CharField(max_length=80, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["user_address", "token_address"],
                        name="claims_clai_user_ad_021cb6_idx",
                    ),
                    models.Index(fields=["nonce"], name="claims_clai_nonce_d2aa9e_idx"),
                ],
            },
        ),
        migrations.CreateModel(
            name="ClaimIntent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("token_address", models.CharField(db_index=True, max_length=64)),
                ("token_symbol", models.CharField(db_index=True, max_length=16)),
                ("user_address", models.CharField(db_index=True, max_length=64)),
                ("amount_scaled", models.DecimalField(decimal_places=0, max_digits=65)),
                ("nonce", models.BigIntegerField()),
                ("deadline", models.BigIntegerField()),
                ("signature", models.BinaryField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "pending"),
                            ("confirmed", "confirmed"),
                            ("expired", "expired"),
                            ("cancelled", "cancelled"),
                        ],
                        default="issued",
                        max_length=16,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["user", "token_symbol"], name="claims_clai_user_id_086d37_idx"
                    ),
                    models.Index(fields=["user_address"], name="claims_clai_user_ad_9c4f1f_idx"),
                    models.Index(fields=["nonce"], name="claims_clai_nonce_782fce_idx"),
                ],
                "unique_together": {("user", "nonce")},
            },
        ),
    ]
