# Generated by Django 4.2.6 on 2025-10-09 17:22

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Badge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("key", models.SlugField(max_length=64, unique=True)),
                ("name", models.CharField(max_length=128)),
                ("description", models.TextField(blank=True)),
                ("image", models.ImageField(blank=True, null=True, upload_to="badges/")),
                ("reward_rate_bp", models.PositiveIntegerField(default=0)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("GENERIC", "Generic/Manual"),
                            ("REFERRAL", "Referral Threshold"),
                            ("WHALE", "Whale (no-unstake period)"),
                            ("LEVEL5", "Started a Level-5 Miner"),
                            ("TOP_ROI", "Top ROI Achiever"),
                            ("FIRST_N", "First N Users (giveaway)"),
                        ],
                        default="GENERIC",
                        max_length=16,
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("limit_count", models.PositiveIntegerField(blank=True, null=True)),
                ("referral_threshold", models.PositiveIntegerField(blank=True, null=True)),
                ("whale_months", models.PositiveIntegerField(blank=True, null=True)),
                ("roi_threshold_bp", models.PositiveIntegerField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="UserBadge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("awarded_at", models.DateTimeField(auto_now_add=True)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "badge",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="badges.badge"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="badge",
            index=models.Index(fields=["type"], name="badges_badg_type_d1b809_idx"),
        ),
        migrations.AddIndex(
            model_name="badge",
            index=models.Index(fields=["is_active"], name="badges_badg_is_acti_c4a4f2_idx"),
        ),
        migrations.AddIndex(
            model_name="userbadge",
            index=models.Index(fields=["user"], name="badges_user_user_id_c733bd_idx"),
        ),
        migrations.AddIndex(
            model_name="userbadge",
            index=models.Index(fields=["badge"], name="badges_user_badge_i_014643_idx"),
        ),
        migrations.AlterUniqueTogether(
            name="userbadge",
            unique_together={("user", "badge")},
        ),
    ]
