# apps/badges/management/commands/rank_top_roi.py

# django
from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand

# local
from apps.badges.services import TOP_ROI_30D, _roi_30d, award_badge, revoke_badge

U = get_user_model()


class Command(BaseCommand):
    help = "Compute ROI 30d for all users and award Top ROI badge to top N (default 1)."

    def add_arguments(self, parser):
        parser.add_argument("--top", type=int, default=1, help="Number of winners (default: 1)")

    def handle(self, *args, **kwargs):
        top_n = kwargs["top"]
        scores = []
        for u in U.objects.all().iterator():
            scores.append((u.id, _roi_30d(u)))
        scores.sort(key=lambda x: x[1], reverse=True)

        winners = set([uid for uid, _ in scores[:top_n] if scores and scores[0][1] > 0])
        # اعطا به برنده‌ها، لغو از بقیه
        for uid, _ in scores:
            u = U.objects.get(id=uid)
            if uid in winners:
                award_badge(u, TOP_ROI_30D)
            else:
                revoke_badge(u, TOP_ROI_30D)

        self.stdout.write(
            self.style.SUCCESS(f"Awarded {len(winners)} Top ROI badges; revoked from others.")
        )
