from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand

from apps.badges.services import award_all_for_user, award_top_roi_badge

U = get_user_model()


class Command(BaseCommand):
    help = "Award badges (referral/whale for all users) + Top ROI by threshold"

    def add_arguments(self, parser):
        parser.add_argument(
            "--roi-threshold", type=float, default=1.5, help="ROI threshold, default 1.5"
        )

    def handle(self, *args, **opts):
        cnt_users = 0
        for user in U.objects.all().iterator():
            awarded = award_all_for_user(user)
            if awarded:
                cnt_users += 1
        self.stdout.write(
            self.style.SUCCESS(f"Awarded referral/whale for {cnt_users} users (where eligible).")
        )

        created = award_top_roi_badge(opts["roi_threshold"])
        self.stdout.write(
            self.style.SUCCESS(
                f"Awarded TOP ROI to {created} users (threshold={opts['roi_threshold']})."
            )
        )
