# Generated by Django 4.2.6 on 2025-09-02 09:23

from decimal import Decimal

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("token_app", "0002_token_contract_address_token_decimals_tokensettings"),
        ("wallets", "0006_pendingreward_processing_started_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="OutgoingTransaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("token_contract", models.CharField(max_length=255)),
                (
                    "amount",
                    models.DecimalField(decimal_places=18, default=Decimal("0"), max_digits=36),
                ),
                ("tx_hash", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[("sending", "Sending"), ("sent", "Sent"), ("failed", "Failed")],
                        default="sending",
                        max_length=20,
                    ),
                ),
                ("details", models.JSONField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "token",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="outgoing_transactions",
                        to="token_app.token",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="outgoing_transactions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(fields=["status"], name="wallets_out_status_1bd65b_idx"),
                    models.Index(fields=["tx_hash"], name="wallets_out_tx_hash_d49b1b_idx"),
                ],
            },
        ),
    ]
