# apps/wallets/constants.py
from drf_yasg import openapi

from django.conf import settings

# در محیط dev اگر env نداشتیم، دیفالت امن/بی‌خطر بده
SERVER_WALLET_ADDRESS = getattr(
    settings, "SERVER_WALLET_ADDRESS", "0x0000000000000000000000000000000000000000"
)
SERVER_WALLET_PRIVATE_KEY = getattr(settings, "SERVER_WALLET_PRIVATE_KEY", "0x" + "0" * 64)

# مثلا BSC یا هر شبکه‌ای؛ فقط جهت لاگ/رسید ساختگی
BSC_CHAIN_ID = int(getattr(settings, "CHAIN_ID", 56))

# زمان انتظار (اگه واقعاً وصل شدیم)
WAIT_RECEIPT_TIMEOUT = int(getattr(settings, "WAIT_RECEIPT_TIMEOUT", 30))

# RPC برای زمانی که بعداً واقعاً وصل شدیم
RPC_URL = getattr(settings, "RPC_URL", None)

# فلگ حالت ساختگی (mock)
CHAIN_MOCK_MODE = bool(getattr(settings, "CHAIN_MOCK_MODE", True))


# ثابت برای Swagger و Idempotency
IDEMPOTENCY_HEADER = openapi.Parameter(
    "Idempotency-Key",
    openapi.IN_HEADER,
    description="Idempotency key to prevent duplicate submissions",
    type=openapi.TYPE_STRING,
    required=False,
)
