# apps/users/urls.py
from django.urls import path

from . import views

urlpatterns = [
    path("auth/email/", views.SendEmailCodeView.as_view()),
    path("auth/verify-code/", views.VerifyCodeView.as_view()),
    path("auth/set-username/", views.SetUsernameView.as_view()),
    path("auth/pass_login/", views.EmailPasswordLoginView.as_view()),
    path("auth/google/", views.GoogleLoginView.as_view()),
    path(
        "request-password-reset/",
        views.RequestPasswordResetView.as_view(),
        name="request_password_reset",
    ),
    path("reset-password/", views.ResetPasswordView.as_view(), name="reset_password"),
    path("me/", views.MeView.as_view(), name="users-me"),
    path("me/profile/", views.ProfileUpdateView.as_view(), name="users-profile-update"),
    path(
        "referral-power-bonus/", views.ReferralPowerBonusView.as_view(), name="referral-power-bonus"
    ),
    path("logout/", views.LogoutView.as_view(), name="logout"),
    path("auth/wallet_signup/", views.WalletSignupView.as_view(), name="wallet-signup"),
    path("auth/wallet_login/", views.WalletLoginView.as_view(), name="wallet-login"),
    path("referral/invites/", views.ReferralInviteView.as_view(), name="referral-invite"),
    path(
        "referral/invites/rotate/",
        views.ReferralInviteRotateView.as_view(),
        name="referral-invite-rotate",
    ),
    path("referral/stats/", views.ReferralStatsView.as_view(), name="referral-stats"),
    path("referral/resolve", views.ReferralResolveView.as_view(), name="referral-resolve"),
    path("referral/my", views.ReferralMyCodeView.as_view(), name="referral-my"),
    path("referral/rotate", views.ReferralRotateCodeView.as_view(), name="referral-rotate"),
    path(
        "referral/invites/create/",
        views.ReferralInviteCreateView.as_view(),
        name="referral-invite-create",
    ),
    path("referral/list", views.ReferralListView.as_view(), name="referral-list"),
    path(
        "email/change/request", views.EmailChangeRequestView.as_view(), name="email-change-request"
    ),
    path(
        "email/change/confirm", views.EmailChangeConfirmView.as_view(), name="email-change-confirm"
    ),
]
