from decimal import Decimal

from django.contrib.auth import get_user_model
from django.test import TestCase

from apps.users.services.referrals import compute_final_percent

U = get_user_model()


class TestReferralPercent(TestCase):
    def test_base_percent_no_refs(self):
        u = U.objects.create(email="x@y.z", is_active=True)
        eff = compute_final_percent(u, Decimal("4.5"))
        self.assertTrue(isinstance(eff, Decimal))
        self.assertGreater(eff, Decimal("0"))
