from django.core.management.base import BaseCommand

from apps.users.models import ReferralRelation
from apps.users.services.referrals import recompute_relation_active


class Command(BaseCommand):
    help = "Recompute ReferralRelation.active for all invitees"

    def handle(self, *args, **options):
        cnt = 0
        for rel in ReferralRelation.objects.select_related("invitee").all():
            recompute_relation_active(rel.invitee)
            cnt += 1
        self.stdout.write(self.style.SUCCESS(f"Recomputed {cnt} relations."))
