from rest_framework import serializers

from .models import Ticket, TicketCategory, TicketMessage, TicketPriority, TicketStatus


class TicketMessageSerializer(serializers.ModelSerializer):
    author_name = serializers.SerializerMethodField()

    class Meta:
        model = TicketMessage
        fields = ["id", "author", "author_name", "from_staff", "body", "created_at"]
        read_only_fields = ["id", "author", "author_name", "from_staff", "created_at"]

    def get_author_name(self, obj):
        return getattr(obj.author, "username", str(obj.author_id))


class TicketSerializer(serializers.ModelSerializer):
    messages = TicketMessageSerializer(many=True, read_only=True)

    class Meta:
        model = Ticket
        fields = [
            "id",
            "subject",
            "category",
            "priority",
            "status",
            "created_at",
            "updated_at",
            "messages",
        ]
        read_only_fields = ["id", "status", "created_at", "updated_at", "messages"]


class TicketCreateSerializer(serializers.ModelSerializer):
    class Meta:
        model = Ticket
        fields = ["subject", "category", "priority"]


class TicketReplySerializer(serializers.Serializer):
    body = serializers.CharField(min_length=1, max_length=8000)
