from django.conf import settings
from django.core.mail import EmailMultiAlternatives

from .email_renderer import render_ticket_response_email

def send_ticket_reply_email_to_user(ticket, message):
    """
    این تابع وقتی صدا زده می‌شود که ادمین/استاف روی تیکت جواب دهد.
    برای صاحب تیکت ایمیل می‌فرستیم.
    """
    to_email = ticket.user.email
    if not to_email:
        return

    subject, html_body, text_body = render_ticket_response_email(ticket, message)

    email = EmailMultiAlternatives(
        subject=subject,
        body=text_body,  # نسخه plain text
        from_email=settings.DEFAULT_FROM_EMAIL,
        to=[to_email],
    )
    email.attach_alternative(html_body, "text/html")  # نسخه HTML
    print("DEBUG EMAIL >>>", ticket.id, ticket.subject, message.body)
    print(html_body)
    print("DEBUG dashboard_url =", dashboard_url)
    print(html_body)

    print("<<< DEBUG EMAIL END")
    email.send(fail_silently=False)
    
def send_ticket_reply_email_to_staff(ticket, message):
    support_email = getattr(settings, "SUPPORT_EMAIL", settings.DEFAULT_FROM_EMAIL)
    if not support_email:
        return

    subject, html_body, text_body = render_ticket_response_email(ticket, message)
    subject = f"User replied to Ticket #{ticket.id}: {ticket.subject}"

    email = EmailMultiAlternatives(
        subject=subject,
        body=text_body,
        from_email=settings.DEFAULT_FROM_EMAIL,
        to=[support_email],
    )
    email.attach_alternative(html_body, "text/html")
    email.send(fail_silently=False)
