
from django.conf import settings
from django.template.loader import render_to_string
from django.utils.html import strip_tags
from django.utils import timezone


def render_ticket_response_email(ticket, message):
    """
    ticket: Ticket instance
    message: TicketMessage instance
    خروجی: (subject, html_body, text_body)
    """

    website_url = getattr(settings, "WEBSITE_URL", "https://coinmaining.game")

    dashboard_url = f"{website_url}/dashboard/support/ticket/{ticket.id}"

    context = {
        "website_url": website_url,
        "dashboard_url": dashboard_url,
        "support_url": f"{website_url}/support/",
        "unsubscribe_url": f"{website_url}/unsubscribe/",
        "ticket": ticket,
        "message": message,
        "response_date": timezone.now(),
    }

    html_body = render_to_string("email/support_reply.html", context)
    text_body = strip_tags(html_body)

    subject = f"Support Response - Ticket #{ticket.id}: {ticket.subject}"

    return subject, html_body, text_body
