# plan/urls.py

from rest_framework.routers import DefaultRouter

from django.urls import include, path

from .views import PlanDetailPublicView, PlanListPublicView, PlanViewSet, resolve_plan_by_amount

router = DefaultRouter()
router.register(r"plans", PlanViewSet, basename="plan")

urlpatterns = [
    path("", include(router.urls)),
    path("resolve/", resolve_plan_by_amount, name="resolve_plan"),
    path("public/", PlanListPublicView.as_view(), name="plans-public-list"),
    path("public/<int:plan_id>/", PlanDetailPublicView.as_view(), name="plans-public-detail"),
]
