from rest_framework import serializers

from apps.plans.models import Plan
from apps.plans.serializers import PlanPublicSerializer
from apps.token_app.serializers import TokenSerializer

from .models import Miner


class MinerSerializer(serializers.ModelSerializer):
    plan_id = serializers.PrimaryKeyRelatedField(
        queryset=Plan.objects.all(), source="plan", write_only=True
    )
    tokens = TokenSerializer(many=True, read_only=True)

    class Meta:
        model = Miner
        fields = [
            "id",
            "plan_id",
            "tokens",
            "name",
            "staked_amount",
            "power",
            "is_online",
            "created_at",
        ]
        read_only_fields = ["power", "created_at"]


class MinerPublicSerializer(serializers.ModelSerializer):
    plan = PlanPublicSerializer(read_only=True)
    tokens = serializers.SlugRelatedField(slug_field="symbol", many=True, read_only=True)

    class Meta:
        model = Miner
        fields = ["id", "name", "power", "is_online", "plan", "tokens"]


class MinerLightSerializer(serializers.ModelSerializer):
    """برای لیست سبک public"""

    plan_id = serializers.SerializerMethodField()
    plan_name = serializers.SerializerMethodField()

    class Meta:
        model = Miner
        fields = ("id", "name", "plan_id", "plan_name", "is_online")

    def get_plan_id(self, obj):
        return getattr(getattr(obj, "plan", None), "id", None)

    def get_plan_name(self, obj):
        return getattr(getattr(obj, "plan", None), "name", None)
