from django.db import models

class TaskKind(models.TextChoices):
    ONE_TIME = "one_time", "One-time"
    WEEKLY = "weekly", "Weekly"
    MONTHLY = "monthly", "Monthly"
    EVENT = "event", "Event (custom window)"

class TaskConditionCode(models.TextChoices):
    LOGIN_STREAK = "login_streak", "Login N days in a row"
    WEEKLY_RESTAKE_ALL = "weekly_restake_all", "Restake all weekly profit"
    MINERS_ACTIVE_WINDOW = "miners_active_window", "All miners active in window"
    REFERRAL_ACTIVE_COUNT = "referral_active_count", "N active referrals in window"

class RewardType(models.TextChoices):
    ENERGY_TURBO = "energy_turbo", "Energy Turbo"
    MINER_ACCESS = "miner_access", "Temporary Miner Access"

class ProgressStatus(models.TextChoices):
    PENDING = "pending", "Pending"
    COMPLETED = "completed", "Completed"
    REWARDED = "rewarded", "Rewarded"