# apps/claims/admin.py
from django.contrib import admin
from .models import ClaimTx, ClaimIntent


@admin.register(ClaimTx)
class ClaimTxAdmin(admin.ModelAdmin):
    list_display = ("tx_hash", "token_symbol", "amount_scaled", "nonce",
                    "user_address", "token_address", "created_at")
    search_fields = ("tx_hash", "user_address", "token_address")
    list_filter = ("token_symbol",)  # فقط فیلدهای واقعی مدل
    ordering = ("-id",)


@admin.register(ClaimIntent)
class ClaimIntentAdmin(admin.ModelAdmin):
    list_display = ("id", "user", "token_symbol", "amount_scaled", "nonce",
                    "deadline", "created_at")
    search_fields = ("user__email", "user__username", "user_address", "token_address", "token_symbol")
    list_filter = ("token_symbol",)  
    ordering = ("-id",)
