
# apps/badges/views.py
from rest_framework.permissions import AllowAny, IsAuthenticated
from rest_framework.response import Response
from rest_framework.views import APIView
from collections import defaultdict
from django.db.models import F, Case, When, IntegerField
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework.permissions import AllowAny
from .models import Badge
from .serializers import BadgeSerializer
from .models import Badge, UserBadge
from .serializers import BadgeSerializer, UserBadgeSerializer
from .services import user_badge_bonus_bp, evaluate_badges_for_user

class BadgeListView(APIView):
    permission_classes = [AllowAny]

    def get(self, request):
        qs = Badge.objects.filter(is_active=True).order_by("id")
        return Response(BadgeSerializer(qs, many=True, context={"request": request}).data)

class MyBadgesView(APIView):
    permission_classes = [IsAuthenticated]

    def get(self, request):
        try:
            evaluate_badges_for_user(request.user)
        except Exception:
            pass
        q = UserBadge.objects.select_related("badge").filter(user=request.user)
        data = UserBadgeSerializer(q, many=True, context={"request": request}).data
        return Response({
            "bonus_bp": user_badge_bonus_bp(request.user),
            "badges": data
        })



RARITY_WEIGHT = {"COMMON": 10, "UNCOMMON": 20, "RARE": 30, "EPIC": 40}

class BadgeListOrderedView(APIView):
    permission_classes = [AllowAny]

    def get(self, request):
        # annotate با وزن rarity
        whens = [When(rarity=k, then=v) for k, v in RARITY_WEIGHT.items()]
        qs = (
            Badge.objects.filter(is_active=True)
            .annotate(rw=Case(*whens, default=100, output_field=IntegerField()))
            .order_by("rw", "display_order", "id")
        )

        # حالت 1: فلتِ مرتب
        flat = BadgeSerializer(qs, many=True).data

        # حالت 2: گروه‌بندی با محدودیت‌ مد‌نظر مدیر
        buckets = defaultdict(list)
        for b in flat:
            buckets[b["rarity"]].append(b)

        # اعمال محدودیت: 2 تا Common، 2 تا Uncommon، Rare/Epic بدون محدودیت
        grouped = {
            "COMMON": buckets.get("COMMON", [])[:2],
            "UNCOMMON": buckets.get("UNCOMMON", [])[:2],
            "RARE": buckets.get("RARE", []),
            "EPIC": buckets.get("EPIC", []),
        }

        # همچنین خروجی merge شده‌ی نهایی با ترتیب خواسته:
        merged_display = grouped["COMMON"] + grouped["UNCOMMON"] + grouped["RARE"] + grouped["EPIC"]

        return Response(
            {
                "ordered_flat": flat,              # اگر فرانت بخواد خودش کنترل کنه
                "grouped": grouped,               # اگر فرانت بخواد با سکشن نشون بده
                "ordered_for_display": merged_display,  # دقیقاً ترتیب خواستهٔ مدیر
            }
        )