from django.db import migrations

SQLS = [
    # --- badges_badge: ستون‌هایی که در کد استفاده می‌کنیم ---
    # First-N giveaway
    "ALTER TABLE badges_badge ADD COLUMN IF NOT EXISTS limit_count INT NULL",
    # Referral threshold (5/10/25/50)
    "ALTER TABLE badges_badge ADD COLUMN IF NOT EXISTS referral_threshold INT NULL",
    # Whale/Loyal ماه‌ها
    "ALTER TABLE badges_badge ADD COLUMN IF NOT EXISTS whale_months INT NULL",
    # Top ROI threshold بر حسب basis points (مثلاً 15000 = 1.5x)
    "ALTER TABLE badges_badge ADD COLUMN IF NOT EXISTS roi_threshold_bp INT NULL",

    # ایندکس‌های ساده (اختیاری ولی بد نیست – اگر نبود ایجاد کن)
    "CREATE INDEX IF NOT EXISTS badges_badge_limit_count_idx ON badges_badge (limit_count)",
    "CREATE INDEX IF NOT EXISTS badges_badge_ref_thr_idx ON badges_badge (referral_threshold)",
    "CREATE INDEX IF NOT EXISTS badges_badge_whale_m_idx ON badges_badge (whale_months)",
    "CREATE INDEX IF NOT EXISTS badges_badge_roi_bp_idx ON badges_badge (roi_threshold_bp)",

    # --- badges_userbadge: مطمئن شو is_active هست (قبلاً هم خورده بود خطاش) ---
    "ALTER TABLE badges_userbadge ADD COLUMN IF NOT EXISTS is_active TINYINT(1) NOT NULL DEFAULT 1",
    "CREATE INDEX IF NOT EXISTS badges_userbadge_is_active_idx ON badges_userbadge (is_active)",
]

def forwards(apps, schema_editor):
    with schema_editor.connection.cursor() as cur:
        for stmt in SQLS:
            cur.execute(stmt)

def backwards(apps, schema_editor):
    # Rollback ایمن: حذف نکن (در پروداکشن نیازی نیست)
    pass

class Migration(migrations.Migration):

    dependencies = [
        ("badges", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(forwards, backwards),
    ]