from django.db import migrations

class Migration(migrations.Migration):

    dependencies = [
        ("badges", "0001_initial"),
    ]

    operations = [
        migrations.RunSQL(
            # MariaDB/MySQL: ستون را اگر وجود ندارد اضافه کن
            sql="""
            ALTER TABLE badges_userbadge
              ADD COLUMN IF NOT EXISTS is_active TINYINT(1) NOT NULL DEFAULT 1,
              ADD INDEX IF NOT EXISTS idx_userbadge_user_active (user_id, is_active);
            """,
            reverse_sql="""
            ALTER TABLE badges_userbadge
              DROP INDEX idx_userbadge_user_active;
            ALTER TABLE badges_userbadge
              DROP COLUMN is_active;
            """,
        ),
    ]