from django.db.models.signals import post_delete, post_save
from django.dispatch import receiver

from apps.stakes.models import Stake
from apps.users.models import ReferralRelation


def _recalc_referral_active_for_user(user):
    has_active = Stake.objects.filter(user=user, is_active=True).exists()
    ReferralRelation.objects.filter(invitee=user).update(active=has_active)


@receiver(post_save, sender=Stake)
def stake_saved(sender, instance, **kwargs):
    _recalc_referral_active_for_user(instance.user)


@receiver(post_delete, sender=Stake)
def stake_deleted(sender, instance, **kwargs):
    _recalc_referral_active_for_user(instance.user)
