from django.db import migrations, models
from django.utils.crypto import get_random_string


def fill_missing_usernames(apps, schema_editor):
    User = apps.get_model("users", "User")
    # هر کاربری که username تهی/NULL دارد، یک temp_XXXXXXXX بگیرد
    qs = User.objects.filter(models.Q(username__isnull=True) | models.Q(username__exact=""))
    for u in qs.iterator():
        # اگر ایمیل دارد، از پیشوند temp_ استفاده کن که یونیک بماند
        base = "temp_" + get_random_string(8).lower()
        # اطمینان از یکتا بودن:
        candidate = base
        i = 1
        while User.objects.filter(username__iexact=candidate).exists():
            i += 1
            candidate = f"{base}{i}"
        u.username = candidate
        u.save(update_fields=["username"])


class Migration(migrations.Migration):
    # 0015_user_cleanup_require_username.py
    dependencies = [
        ("users", "0014_rename_use_count_referralinvite_used_count"),
    ]

    operations = [
        migrations.RunPython(fill_missing_usernames, migrations.RunPython.noop),
    ]
