# apps/users/constants.py

# ساخت دیکشنری با 125 آواتار
DEFAULT_AVATARS = {
    f"pr-{i}": f"https://coinmaining.game/profiles/pr-{i}.jpeg" for i in range(1, 126)
}

# کلیدها
DEFAULT_AVATAR_KEYS = list(DEFAULT_AVATARS.keys())

# پیشفرض بزاریم مثلا pr-1
DEFAULT_AVATAR_FALLBACK = "pr-1"


def resolve_avatar_url(key: str) -> str:
    """بر اساس کلید، URL آواتار بده"""
    return DEFAULT_AVATARS.get(key, DEFAULT_AVATARS[DEFAULT_AVATAR_FALLBACK])
