# Generated by Django 5.2.3 on 2025-06-29 21:39

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("plans", "__first__"),
        ("token_app", "__first__"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Miner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(default="Miner", max_length=255)),
                ("staked_amount", models.DecimalField(decimal_places=8, default=0, max_digits=30)),
                ("power", models.FloatField(default=0)),
                ("is_online", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "plan",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="plans.plan"),
                ),
                (
                    "token",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="token_app.token"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="miners",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UserMiner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("staked_amount", models.DecimalField(decimal_places=8, default=0, max_digits=30)),
                ("is_online", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "miner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="miners.miner"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_miners",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
