from django.core.management.base import BaseCommand
from django.utils import timezone
from apps.events.models import UserEnergyBoost, UserTemporaryMinerAccess

class Command(BaseCommand):
    help = "Expire time-limited rewards (energy boosts, miner accesses)"

    def handle(self, *args, **options):
        now = timezone.now()
        n1 = UserEnergyBoost.objects.filter(is_active=True, ends_at__lt=now).update(is_active=False)
        n2 = UserTemporaryMinerAccess.objects.filter(is_active=True, ends_at__lt=now).update(is_active=False)
        total = n1 + n2
        self.stdout.write(self.style.SUCCESS(f"Expired {total} records (EnergyBoost={n1}, MinerAccess={n2})"))
