# apps/claims/urls.py
from django.urls import path
from .views import ClaimSignView, QuickNodeClaimedWebhookView, UserClaimIntentsAdminView

urlpatterns = [
    path("claim/sign/", ClaimSignView.as_view(), name="claim-sign"),
    path("webhook/quicknode/claimed/", QuickNodeClaimedWebhookView.as_view(), name="qn-claimed-webhook"),
    path("user-claim-intents/<int:user_id>/", UserClaimIntentsAdminView.as_view(), name="user-claim-intents-admin"),
]
