
# apps/badges/management/commands/seed_badges.py
from django.core.management.base import BaseCommand
from apps.badges.models import Badge

BADGES = [
    dict(key="first_100", name="First 100", description="Awarded to the first 100 registered users.",
         type="FIRST_N", limit_count=100, reward_rate_bp=10, is_active=True),

    dict(key="referral_5",  name="Referrer I", description="Reached 5 active referrals.",
         type="REFERRAL", referral_threshold=5,  reward_rate_bp=5, is_active=True),
    dict(key="referral_10", name="Referrer II", description="Reached 10 active referrals.",
         type="REFERRAL", referral_threshold=10, reward_rate_bp=10, is_active=True),
    dict(key="referral_25", name="Referrer III", description="Reached 25 active referrals.",
         type="REFERRAL", referral_threshold=25, reward_rate_bp=20, is_active=True),
    dict(key="referral_50", name="Referrer IV", description="Reached 50 active referrals.",
         type="REFERRAL", referral_threshold=50, reward_rate_bp=30, is_active=True),

    dict(key="level5_starter", name="Pro Miner", description="Started a Level 5 miner.",
         type="LEVEL5", reward_rate_bp=10, is_active=True),

    dict(key="loyal_6m", name="Loyal Staker", description="Had an active stake for 6 months.",
         type="WHALE", whale_months=6, reward_rate_bp=15, is_active=True),

    dict(key="top_roi_1_5", name="Top ROI", description="Achieved 1.5x ROI multiple.",
         type="TOP_ROI", roi_threshold_bp=15000, reward_rate_bp=25, is_active=True),
]

class Command(BaseCommand):
    help = "Seed default badges (create or update)"

    def handle(self, *args, **kwargs):
        for data in BADGES:
            key = data["key"]
            obj, created = Badge.objects.update_or_create(key=key, defaults=data)
            self.stdout.write(self.style.SUCCESS(f"{'CREATED' if created else 'UPDATED'}: {obj.key}"))
