# apps/badges/management/commands/award_loyal_6m.py
from django.core.management.base import BaseCommand
from django.contrib.auth import get_user_model
from apps.badges.services import maybe_award_loyal_6m

User = get_user_model()

class Command(BaseCommand):
    help = "Scan users and award loyal_6m if eligible"

    def handle(self, *args, **kwargs):
        for u in User.objects.all().iterator():
            if maybe_award_loyal_6m(u):
                self.stdout.write(self.style.SUCCESS(f"loyal_6m awarded to {u.id}"))