from django.contrib import admin
from .models import Badge, UserBadge

@admin.register(Badge)
class BadgeAdmin(admin.ModelAdmin):
    list_display = ("id", "key", "name", "type","rarity", "display_order", "reward_rate_bp", "is_active", "limit_count", "referral_threshold", "roi_threshold_bp", "whale_months")
    list_filter = ("rarity","type", "is_active")
    search_fields = ("key", "name", "description")
    readonly_fields = ("created_at",)
    list_editable = ("rarity", "display_order", "is_active")
    ordering = ("rarity", "display_order", "id")
    fieldsets = (
        (None, {
            "fields": ("key", "name", "description", "image", "is_active")
        }),
        ("Reward", {
            "fields": ("reward_rate_bp",)
        }),
        ("Logic", {
            "fields": ("type", "limit_count", "referral_threshold", "roi_threshold_bp", "whale_months")
        }),
        ("Meta", {
            "fields": ("created_at",)
        }),
    )

@admin.register(UserBadge)
class UserBadgeAdmin(admin.ModelAdmin):
    list_display = ("id", "user", "badge", "is_active", "awarded_at")
    list_filter = ("is_active", "badge__type")
    search_fields = ("user__email", "badge__key", "badge__name")
    autocomplete_fields = ("user", "badge")
    readonly_fields = ("awarded_at",)
    


    
